<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Helpers\UserSystemInfoHelper;
use App\Models\QuizLog;
use App\Models\Member;

class MemberLoginController extends Controller
{
    public function getLogin(Request $request){
        return view('memberlogin');
    }
    public function postLogin(Request $request)
    {   
       
        $category = $request->category;
        
        $member_id = $request->member_id;
       
        $membership_no1 = $request->membership_no;
        $membership_no = $category.'-'.$membership_no1;
       
        $mail_mobile = $request->mail_mobile;
        $mail_email = $request->mail_email;
        $getip = UserSystemInfoHelper::get_ip();
        $getbrowser = UserSystemInfoHelper::get_browsers();
        $getdevice = UserSystemInfoHelper::get_device();
        $getos = UserSystemInfoHelper::get_os();
        

      
       
        $member=Member::where('membership_no', $membership_no)->where('mail_email',$mail_email)->orWhere('mail_mobile',$mail_mobile)->first();
        // dd($member);
        if($member){

            $quizlog =[
              
               
                     'member_id' => $member->member_id,
                     'ip_address' => $getip,
                      'browser'=> $getbrowser,
                      'device' => $getdevice,
                      'os'    => $getos,
                    
                ];
            //    dd($quizlog);
                QuizLog::create($quizlog);
           Auth::login($member);
            return redirect('/quiz');
        }
        // if(Auth::guard('member')->attempt(['membership_no' => $membership_no, 'mail_email' => $mail_email])){
        //     return redirect('/quiz');
        // }
        else{
            return redirect()->back()->with('error-message',"Member Type,Member No and Member Email is Incorrect!")->withInput();
        }
       
    }
    // public function logout(Request $request){
    //     Auth::logout();
    //     return redirect('/memberlogin');
    // }

//     function getusersysteminfo()
//   {
    
//     $getip = UserSystemInfoHelper::get_ip();
//     $getbrowser = UserSystemInfoHelper::get_browsers();
//     $getdevice = UserSystemInfoHelper::get_device();
//     $getos = UserSystemInfoHelper::get_os();

//     echo "<center>$getip <br> $getdevice <br> $getbrowser <br> $getos</center>";
//   }

//   public function store(Request $request)
//     {
//         $getip = UserSystemInfoHelper::get_ip();
//         $getbrowser = UserSystemInfoHelper::get_browsers();
//         $getdevice = UserSystemInfoHelper::get_device();
//         $getos = UserSystemInfoHelper::get_os();

//         $member = new Member;
//         $member->membership_no = $request->membership_no;
//         $member->save();
//         $quizlog = new QuizLog;
//         $quizlog->member_id = $request->member_id;
//         $quizlog->ip_address = $request->$getip;
//         $quizlog->device = $request-> $getbrowser;
//         $quizlog->browser = $request->$getdevice;
//         $quizlog->os = $request->$getos;
//         $quizlog->save();
        
//     }
 }
