<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\User;

class AdminLoginController extends Controller
{
    public function getLogin(Request $request){
        return view('admin.login');
    }
    public function postLogin(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'email' => 'required',
            'password' => 'required|min:8'
        ]);
        
        if($validator->fails()){
            return redirect()->back()->withError('message','Enter proper fields');
        }

        $email = $request->email;
        $password = $request->password;
        $user=User::where('email',$email)->where('password',$password)->first();
        if($user){
            Auth::login($user);
            return redirect('/admin/dashboard');
        }
        // if(Auth::User()->attempt(['email' => $email, 'password' => $password,'membership'=>'2'])){
        //     return redirect('/admin/membership');
        // }
        else{
            return redirect()->back()->with('error',"Username or Password is incorrect!")->withInput();
        }
    }
    public function logout(Request $request){
        Auth::logout();
        return redirect('/admin/login');
    }
}
