<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Question;
use App\Models\Options;
use App\Models\UserAnswer;
use Carbon\Carbon;
use DateTime;
use Date;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;



class QuizController extends Controller
{
    
  
public  $file_path = "uploads/Quiz_files/Image"; 

 public $file_path1 = "uploads/Quiz_files/Video";
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() 
    {
           
            $check = Auth::guard('member')->check();
    	if(Auth::guard('member')->check()){
    	    $memberid=Auth::guard('member')->user()->member_id;
    	    $datetime = Carbon::now();
    	   $datetime1 = $datetime->addHours(5);
    	   $datetime2 = $datetime1->addMinutes(30);
    	   // dd($datetime2);
    	   //   $now = new DateTime();
    	  
            $questions = DB::table('questions')->whereDate('q_date', '=', $datetime2)->first();
            // dd($questions);
            
            $member = DB::table('members')->where('member_id',$memberid)->first();
            
            $options = DB::table('options')->where('question_id',$questions->id)->get();
            // dd($options);
            
            $db_UserAnswer = UserAnswer::where('member_id', $memberid)->where('question_id',$questions->id)->first();
            
            return view('quiz',compact('questions','options','member','db_UserAnswer'));
        }else{
            return redirect('/login');
        }
    
    }
   
   public  function index1(request $request)
   {
    //   $abc="select count(DISTINCT id) as total_count,date(created_at) as date1,(SELECT count(DISTINCT id) from user_answers where is_correct = 1 and date(created_at) = date1) as count_1 from user_answers us GROUP BY date(created_at)";
       
  $results = DB::table('user_answers AS us')
    ->selectRaw('count(DISTINCT us.id) as attempt, date(us.created_at) as date1')
    ->selectSub(function ($query) {
        $query->selectRaw('count(DISTINCT id)')
            ->from('user_answers')
            ->where('is_correct', 1)
            ->whereRaw('date(created_at) = date1');
    }, 'correct')
    
    ->groupBy('date1')
    ->orderBy('date1', 'desc')
    ->get();
    
   
    // $results = DB::table('user_answers AS us')
    // ->selectRaw('count(DISTINCT us.id) as total_count, date_format(us.created_at, "%Y-%m-%d") as date1')
    // ->selectSub(function ($query) {
    //     $query->selectRaw('count(DISTINCT id)')
    //         ->from('user_answers')
    //         ->whereRaw('date(created_at) = date(us.created_at)')
    //         ->where('is_correct', 1)
    //         ->limit(1);
    // }, 'count_1')
    // // ->selectRaw('(count_1 / total_count) * 100 as percentage')
    // ->groupBy('date1')
    // ->orderBy('date1', 'desc')
    // ->get();
    
   
    // $results = DB::table('user_answers AS us')
    // ->selectRaw('count(DISTINCT us.id) as total_count, date(us.created_at) as date1')
    // ->selectSub(function ($query) {
    //     $query->selectRaw('count(DISTINCT id)')
    //         ->from('user_answers')
    //         ->whereRaw('date(created_at) = date(us.created_at)')
    //         ->where('is_correct', 1)
    //         ->limit(1);
    // }, 'count_1')
    // ->selectRaw('(count_1 / total_count) * 100 as percentage')
    // ->groupBy('date1')
    // ->orderBy('date1', 'desc')
    // ->get();
//   dd($results);
    
  
       return view('info',compact('results'));
   }
    

    public function question(Request $request){
        //  dd($request);
        
        $isCorrect = Options::select('is_correct')->where('question_id',$request->question)->where('id',$request->answer)->first();
        $quizdate =  Options::select('quiz_date_id')->where('question_id',$request->question)->where('id',$request->answer)->first();
        // dd($quizdate);
    //   dd($isCorrect);
        try{
            // dd($request->all());
            $question =[
               'member_id' => $request->member_id,
            // 'member_id' => $request->member_id,
                //   'member_id' =>  Auth::member()->member_id,
                 'question_id' => $request->question,
                  'option_id'=> $request->answer,
                  'is_correct'=> $isCorrect->is_correct,
                  'quiz_date_id' => $quizdate->quiz_date_id,
               
                 
                
            ];
            // dd($question);
            UserAnswer::create($question);

            // $que =[
            //     'answer'=> $request->opt1
            // ];
          
            $correctAnswer = Options::select('id','option','option_label','is_correct')->where('question_id',$request->question)
            ->where('is_correct',1)
            // ->orwhere('id',$request->answer)
            ->get();
            $getExplaination_reference = Question::select('explaination','reference')->where('id', $request->question)->get();
            // dd($correctAnswer);
             
              $submittedAnswer = Options::select('id','option','option_label','is_correct')->where('question_id',$request->question)
            ->where('id',$request->answer)
            ->get();
            return  array($submittedAnswer, $correctAnswer, $getExplaination_reference);
            
        } catch (\Exception $ex) {
            Log::info("Exception for question");
            Log::info($ex);
            // return redirect()->back();
            return $ex;
        }
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function viewScore()
    {
             $memberid=Auth::guard('member')->user()->member_id;
            //  $date = UserAnswer::select('created_at')->where('member_id', $memberid)->first();
            //   $date1 = UserAnswer::select('start_date_quiz')->where('member_id', $memberid)->first();
            //  dd($date1);
              $date = DB::table('quiz_date')->where('is_active',1)->first()->start_date;
            // dd($date);
             $questCount = DB::table('user_answers')->where('member_id', $memberid)->where('quiz_date_id','=',1)->count();
            //  dd($questCount);
             $ansCount = DB::table('user_answers')->where('member_id', $memberid)->where('quiz_date_id','=',1)->where('is_correct',1)->count();
            //  dd($ansCount);
            return view('score',compact('questCount','ansCount','date'));
    }
 
    public function viewLastSeven()
    {
        // $date = \Carbon\Carbon::today()->subDays(7);
        // $lastSevenQuestion = Question::select('question')->where('q_date','>=',$date)->get();
        // return view('lastseven',compact('date','lastSevenQuestion'));
        return view('lastseven');
    }
    
    Public function index3()
    {
        return view('adminform');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
     
     public function listing()
     {
          $questions = Question::orderByDesc('q_date')->get();
         return view('listing',compact('questions'));
     }
     
     
    public function store(Request $request)
    {
        // dd($request);
        $existingQuiz = Question::where('q_date', $request->q_date)->first();

        if ($existingQuiz) {
            // Q_date already present, display a message or redirect back with an error
            return redirect()->back()->with('error-message', 'Quiz date already exists. Please select a different date.');
        }
        
       $question = new Question;
        $question->quiz_date_id = $request->quiz_date_id;
        $question->q_date = $request->q_date;
        $question->question = $request->question;
        $question->explaination = $request->explaination;
        $question->reference = $request->reference;
        if ($request->file('image_name')) {
            $image_name = $this->uploadFile($request->file('image_name'), $this->file_path);
            $question->image_name = $image_name;
            $question->is_image = 1; // Set is_image to 1 when an image is present
            
        } else {
            $question->image_name = "0"; // Set image_name to "0" when no image is present
            $question->is_image = 0; // Set is_image to 0 when no image is present
        }
        
     if ($request->file('video_name')) {
            $video_name = $this->uploadFile1($request->file('video_name'), $this->file_path1);
            $question->video_name = $video_name;
            $question->is_video = 1; // Set is_image to 1 when an image is present
        } else {
            $question->video_name = "0"; // Set image_name to "0" when no image is present
            $question->is_video = 0; // Set is_image to 0 when no image is present
        }
    //   dd($request->quiz_date_id);
    //  dd($question);
        $question->save();
        //  dd($question);
        $labels = ['a', 'b', 'c', 'd'];
        for ($i = 1; $i <= 4; $i++) {
            
            $option = new Options;
            $option->question_id = $question->id;
            $option->option = $request->input('option' . $i);
            $option->quiz_date_id = $request->quiz_date_id;
            $option->option_label = $labels[$i - 1]; // Assign label from the array
            $option->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
            // dd($option);
            $option->save();
        }
    

// Redirect to a success page or perform any further actions
        return redirect()->back()->with('success-message', 'Quiz data has been stored successfully.');
    }

    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $question = Question::findOrFail($id);
        $options = Options::where('question_id', $id)->get();
        return view('show', compact('question','options'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $question = Question::findOrFail($id);
         $options = Options::where('question_id', $id)->get();
       
        return view('edit', compact('question','options'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function update(Request $request, $id)
{
    $existingQuiz = Question::where('q_date', $request->q_date)
        ->where('id', '!=', $id)
        ->first();

    if ($existingQuiz) {
        return redirect()->back()->with('error-message', 'Quiz date already exists. Please select a different date.');
    }

    $question = Question::findOrFail($id);
    $question->quiz_date_id = $request->quiz_date_id;
    $question->q_date = $request->q_date;
    $question->question = $request->question;
    $question->explaination = $request->explaination;
    $question->reference = $request->reference;

    if ($request->hasFile('image_name')) {
        $image = $request->file('image_name');
        $image_name = $this->uploadFile($image, $this->file_path);
        $question->image_name = $image_name;
        $question->is_image = 1; // Set is_image to 1 when an image is present
    } else {
        $question->image_name = "0";
        $question->is_image = 0; // Set is_image to 0 when no image is present
    }

    if ($request->hasFile('video_name')) {
        $video = $request->file('video_name');
        $video_name = $this->uploadFile1($video, $this->file_path1);
        $question->video_name = $video_name;
        $question->is_video = 1; // Set is_video to 1 when a video is present
    } else {
        $question->video_name = "0";
        $question->is_video = 0; // Set is_video to 0 when no video is present
    }

    $question->save();

    $labels = ['a', 'b', 'c', 'd'];

    for ($i = 1; $i <= 4; $i++) {
        $option = Options::where('question_id', $question->id)
            ->where('option_label', $labels[$i - 1])
            ->first();

        if ($option) {
            $option->option = $request->input('option' . $i);
            $option->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
            $option->save();
        } else {
            $newOption = new Options;
            $newOption->question_id = $question->id;
            $newOption->option = $request->input('option' . $i);
            $newOption->quiz_date_id = $request->quiz_date_id;
            $newOption->option_label = $labels[$i - 1];
            $newOption->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
            $newOption->save();
        }
    }

    return redirect()->back()->with('success-message', 'Quiz data has been updated successfully.');
}

     
     
     
// public function update(Request $request, $id)
// {
//     $existingQuiz = Question::where('q_date', $request->q_date)
//         ->where('id', '!=', $id)
//         ->first();

//     if ($existingQuiz) {
//         return redirect()->back()->with('error-message', 'Quiz date already exists. Please select a different date.');
//     }

//     $question = Question::findOrFail($id);
//     $question->quiz_date_id = $request->quiz_date_id;
//     $question->q_date = $request->q_date;
//     $question->question = $request->question;
//     $question->explaination = $request->explaination;
//     $question->reference = $request->reference;

//     if ($request->file('image_name')) {
//         $image_name = $this->uploadFile($request->file('image_name'), $this->file_path);
//         // Delete the previous image file if needed
//         if ($question->image_name && $question->image_name !== "0") {
//             Storage::delete($this->file_path . $question->image_name);
//         }
//         $question->image_name = $image_name;
//         $question->is_image = 1; // Set is_image to 1 when an image is present
//     } else {
//          $question->image_name = "0";
//         $question->is_image = 0; // Set is_image to 0 when no image is present
//     }

//         if ($request->file('video_name')) {
//         $video_name = $this->uploadFile1($request->file('video_name'), $this->file_path1);
//         // Delete the previous video file if needed
//         if ($question->video_name && $question->video_name !== "0") {
//             Storage::delete($this->file_path1 . $question->video_name);
//         }
//         $question->video_name = $video_name;
//         $question->is_video = 1; // Set is_video to 1 when a video is present
//     } else {
//          $question->video_name = "0";
//         $question->is_video = 0; // Set is_video to 0 when no video is present
//     }

//     $question->save();

//     $labels = ['a', 'b', 'c', 'd'];

//     for ($i = 1; $i <= 4; $i++) {
//         $option = Options::where('question_id', $question->id)
//             ->where('option_label', $labels[$i - 1])
//             ->first();

//         if ($option) {
//             $option->option = $request->input('option' . $i);
//             $option->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
//             $option->save();
//         } else {
//             $newOption = new Options;
//             $newOption->question_id = $question->id;
//             $newOption->option = $request->input('option' . $i);
//             $newOption->quiz_date_id = $request->quiz_date_id;
//             $newOption->option_label = $labels[$i - 1];
//             $newOption->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
//             $newOption->save();
//         }
//     }

//     return redirect('/listing')->with('success-message', 'Quiz data has been updated successfully.');
// }
     

//   public function update(Request $request, $id)
// {
    

//     $question = Question::findOrFail($id);

//     // Update the question
//     $question->quiz_date_id = $request->quiz_date_id;
//     $question->q_date = $request->q_date;
//     $question->question = $request->question;
//     $question->explaination = $request->explaination;
//     $question->reference = $request->reference;
//   if ($request->file('image_name')) {
//             $image_name = $this->uploadFile($request->file('image_name'), $this->file_path);
//             $question->image_name = $image_name;
//             $question->is_image = 1; // Set is_image to 1 when an image is present
            
//         } else {
//             $question->image_name = "0"; // Set image_name to "0" when no image is present
//             $question->is_image = 0; // Set is_image to 0 when no image is present
//         }
        
//      if ($request->file('video_name')) {
//             $video_name = $this->uploadFile1($request->file('video_name'), $this->file_path1);
//             $question->video_name = $video_name;
//             $question->is_video = 1; // Set is_image to 1 when an image is present
//         } else {
//             $question->video_name = "0"; // Set image_name to "0" when no image is present
//             $question->is_video = 0; // Set is_image to 0 when no image is present
//         }
    
//     $question->save();

//     // Delete existing options
//     Options::where('question_id', $question->id)->delete();

//     $labels = ['a', 'b', 'c', 'd'];
//     for ($i = 1; $i <= 4; $i++) {
//         $option = new Options;
//         $option->question_id = $question->id;
//         $option->option = $request->input('option' . $i);
//         $option->quiz_date_id = $request->quiz_date_id;
//         $option->option_label = $labels[$i - 1]; // Assign label from the array
//         $option->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
//         $option->save();
//     }

//     // Redirect to a success page or perform any further actions
//      return redirect('/listing')->with('success-message', 'Quiz has been updated successfully.');
// }



// public function update(Request $request, $id)
// {
//     $existingQuiz = Question::where('q_date', $request->q_date)
//         ->where('id', '!=', $id)
//         ->first();

//     if ($existingQuiz) {
//         return redirect()->back()->with('error-message', 'Quiz date already exists. Please select a different date.');
//     }

//     $question = Question::findOrFail($id);
//     $question->quiz_date_id = $request->quiz_date_id;
//     $question->q_date = $request->q_date;
//     $question->question = $request->question;
//     $question->explaination = $request->explaination;
//     $question->reference = $request->reference;

//     if ($request->hasFile('image_name')) {
//         // Delete the previous image file if it exists
//         if ($question->image_name !== "0") {
//             // $filePath = storage_path('app/' . $this->file_path . '/' . $question->image_name);
//             // Storage::delete($filePath);
//           Storage::delete($this->file_path . $question->image_name);
//         }

//         $image = $request->file('image_name');
//         $image_name = $this->uploadFile($image, $this->file_path);
//         $question->image_name = $image_name;
//         $question->is_image = 1; // Set is_image to 1 when an image is present
//     } else {
//          $question->image_name = "0";
//         $question->is_image = 0; // Set is_image to 0 when no image is present
//     }

//     if ($request->hasFile('video_name')) {
//         // Delete the previous video file if it exists
//         if ($question->video_name !== "0") {
//             //   $filePath = storage_path('app/' . $this->file_path . '/' . $question->video_name);
//             // Storage::delete($filePath);
//          Storage::delete($this->file_path1 . $question->video_name);
//         }

//         $video = $request->file('video_name');
//         $video_name = $this->uploadFile1($video, $this->file_path1);
//         $question->video_name = $video_name;
//         $question->is_video = 1; // Set is_video to 1 when a video is present
//     } else {
//           $question->video_name = "0";
//         $question->is_video = 0; // Set is_video to 0 when no video is present
//     }

//     $question->save();

//     $labels = ['a', 'b', 'c', 'd'];

//     for ($i = 1; $i <= 4; $i++) {
//         $option = Options::where('question_id', $question->id)
//             ->where('option_label', $labels[$i - 1])
//             ->first();

//         if ($option) {
//             $option->option = $request->input('option' . $i);
//             $option->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
//             $option->save();
//         } else {
//             $newOption = new Options;
//             $newOption->question_id = $question->id;
//             $newOption->option = $request->input('option' . $i);
//             $newOption->quiz_date_id = $request->quiz_date_id;
//             $newOption->option_label = $labels[$i - 1];
//             $newOption->is_correct = $request->has('is_correct' . $i) ? 1 : 0;
//             $newOption->save();
//         }
//     }

//     return redirect()->back()->with('success-message', 'Quiz data has been updated successfully.');
// }

// public function uploadFile($file, $target_dir)
// {
//     $image_name = "Image_" . date('YmdHis') . uniqid() . "." . $file->getClientOriginalExtension();
//     $file->storeAs($target_dir, $image_name);
//     return $image_name;
// }

// public function uploadFile1($file, $target_dir)
// {
//     $video_name = "Video_" . date('YmdHis') . uniqid() . "." . $file->getClientOriginalExtension();
//     $file->storeAs($target_dir, $video_name);
//     return $video_name;
// }


  public function uploadFile($file, $target_dir)
    { 
        //  dd($file);
     
     
        $image_name = "Image_".date('YmdHis'). uniqid() .".".$file->getClientOriginalExtension();
        // dd($image_name);
        if($file->move($target_dir, $image_name)){
            return $image_name;
        }
        else{
            return '';
        }
    }
    
    public function uploadFile1($file, $target_dir)
    { 
        //  dd($file);
     
     
        $image_name = "Video_".date('YmdHis'). uniqid() .".".$file->getClientOriginalExtension();
        // dd($image_name);
        if($file->move($target_dir, $image_name)){
            return $image_name;
        }
        else{
            return '';
        }
    }
    
   

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $question = Question::findOrFail($id);
    Options::where('question_id', $question->id)->delete();
    $question->delete();
        return redirect()->back()->with('success-message', 'Quiz has been deleted successfully.');
    }
}
