// admin.js

// Example JavaScript code for the admin panel

// Function to toggle sidebar
function toggleSidebar() {
  const sidebar = document.getElementById('sidebar');
  sidebar.classList.toggle('sidebar-open');
}

// Function to display a confirmation dialog before deleting
function confirmDelete() {
  return confirm('Are you sure you want to delete this item?');
}

// Function to initialize the admin panel
function initAdminPanel() {
  // Add event listener to sidebar toggle button
  const sidebarToggle = document.getElementById('sidebar-toggle');
  sidebarToggle.addEventListener('click', toggleSidebar);

  // Add event listener to delete buttons
  const deleteButtons = document.querySelectorAll('.delete-button');
  deleteButtons.forEach((button) => {
    button.addEventListener('click', confirmDelete);
  });

  // Add your additional initialization code here
}

// Initialize the admin panel
initAdminPanel();