<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <title>View Questions</title>
</head>
<body>
    <div class="container">
        <h4>Question Details</h4>

        <div class="card">
            <div class="card-body">
                <!--<h6 class="card-title">Question Title</h6>-->
                                <div class="row">

                                    <div class="col-sm-12">
                                        <p class="text-muted"><strong>Question Date:</strong> {{date('d/m/Y',strtotime($question->q_date)) }}</p>
                                    </div><br> 

                                    <div class="col-sm-12">
                                        <p class="text-muted"><strong>Question:</strong> {{ $question->question}}</p>
                                    </div><br> 
                                    
                                    <div class="col-sm-12">
                                        <p class="text-muted"><strong>Options:</strong>
                                            <ul class="list-group">
                                                @foreach ($options as $option)
                                                    <li class="list-group-item @if($option->is_correct == 1) bg-success text-white @endif">{{ $option->option }}</li>
                                                @endforeach
                                             </ul>
                                        </p>
                                        
                                    </div><br>
                                   <div class="col-sm-12">
                                            @foreach ($options as $option)
                                                @if ($option->is_correct == 1)
                                                    <p class="text-muted"><strong>Correct Answer:</strong> {{ $option->option }}</p>
                                                @endif
                                            @endforeach
                                    </div><br>
    

                                    <div class="col-sm-12">

                                       <p class="text-muted"><strong>Explaination:</strong> {{ $question->explaination }}</p>

                                    </div><br>

                                    <div class="col-sm-12">

                                        <p class="text-muted"><strong>Reference:</strong> {{ $question->reference }}</p>

                                    </div><br><br>
                                </div>
            </div>
        </div>

        
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>