<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MemberLoginController;
use App\Http\Controllers\QuizController;
use App\Http\Controllers\AdminDashboardController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });


Route::get("/getusersysteminfo",[App\Http\Controllers\MemberLoginController::class, 'getusersysteminfo']);

Route::post('/store', [App\Http\Controllers\MemberLoginController::class, 'store']);

// Route::get("/login",'MemberLoginController@getLogin');
// Route::post('/login','MemberLoginController@postLogin');
// Route::get('/quiz','QuizController@index');
// Route::get('/logout','MemberLoginController@logout');

Auth::routes();
Route::get('/login', [App\Http\Controllers\MemberLoginController::class, 'getLogin']);
Route::post('/login', [App\Http\Controllers\MemberLoginController::class, 'postLogin']);
Route::get('/logout', [App\Http\Controllers\MemberLoginController::class, 'logout']);
Route::post('/question-module-page', [App\Http\Controllers\QuizController::class, 'question'])->name('question-module-page');
Route::get('/quiz', [App\Http\Controllers\QuizController::class, 'index']);
Route::get('/info', [App\Http\Controllers\QuizController::class, 'index1']);
Route::get('/score',[App\Http\Controllers\QuizController::class, 'viewScore']);
Route::get('/lastseven',[App\Http\Controllers\QuizController::class, 'viewLastSeven']);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
// Route::get('/admin', function () {
//     return view('adminform');
// });
Route::get('/admin', [App\Http\Controllers\QuizController::class, 'index3']);
Route::post('/quiz/store', [App\Http\Controllers\QuizController::class, 'store']);
Route::get('/listing', [App\Http\Controllers\QuizController::class, 'listing']);
Route::get('/questions/{id}', [App\Http\Controllers\QuizController::class, 'show'])->name('show');
Route::get('/questions/{id}/edit', [App\Http\Controllers\QuizController::class, 'edit'])->name('edit');
Route::put('/questions/{id}', [App\Http\Controllers\QuizController::class, 'update'])->name('update');
Route::delete('/questions/{id}', [App\Http\Controllers\QuizController::class, 'destroy'])->name('destroy');

Route::get("/admin/login",'AdminLoginController@getLogin');
Route::post('/admin/login','AdminLoginController@postLogin');
Route::get('/admin/logout','AdminLoginController@logout');
// Route::get('/admin/dashboard','AdminDashboardController@index');

 Route::get('/admin/dashboard',[App\Http\Controllers\AdminDashboardController::class,'index'])->name('admin.dashboard');