<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet">
   <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js" rel="stylesheet">
   <link href="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js" rel="stylesheet">
   <!--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" integrity="sha384-rAHR+X2KsVV8SN46GFv/Fvj2lsI5nIEKFFZa4TepFcYMt2OW6rLGoLVR9v92KFdp" crossorigin="anonymous">-->
</head>
<style>
    .alert.alert-danger {
        color: #c30a0a;
        background-color: #f2dede;
        border-color: #c30a0a;
         text-align: center;
          font-size: 22px;
        font-weight: 700;
        /*text-transform: capitalize;*/
        margin-top: 40px;
    }

    .alert.alert-success {
        color: #f1f1f1;
        background-color: #43A047;
        border-color: #1B5E20;
        text-align: center;
        font-size: 22px;
        font-weight: 700;
        /*text-transform: capitalize;*/
        margin-top: 40px;
    }
</style>

<body>
<div class="container mt-5 mb-5">
    <div class="row">
        <div class="col-md-12">
                   <?php if(session()->has('success-message')): ?>
            <div class="alert alert-success" id="success-message"><?php echo e(session()->get('success-message')); ?>

            </div>
        <?php endif; ?>
        
        <?php if(session()->has('error-message')): ?>
            <div class="alert alert-danger" id="error-message"><?php echo e(session()->get('error-message')); ?>

            </div>
        <?php endif; ?>
            <div class="text-center lh-1 mb-2">
                <h4 class="fw-bold">Quiz Question Listing</h4> 
            </div>
            
                <table class="mt-4 table table-bordered">
                    <thead class="bg-dark text-white">
                         <tr>
                            <th style="text-align: center;">Sr.No.</th>
                            <th style="text-align: center;width:20%;">Question Date</th>
                            <th style="text-align: center;">Question</th>
                            <!--<th style="text-align: center;">Explanation</th>-->
                            <!--<th style="text-align: center;">Reference</th>-->
                            <th style="text-align: center; width:10%;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                       <tbody>
                            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="text-align: center;"><?php echo e($key + 1); ?></td>
                                    <td style="text-align: center;"><?php echo e(date('d/m/Y',strtotime($question->q_date))); ?></td>
                                    <td style="text-align: center;"><?php echo e($question->question); ?></td>
                                    <!--<td style="text-align: center;"><?php echo e($question->explaination); ?></td>-->
                                    <!--<td style="text-align: center;"><?php echo e($question->reference); ?></td>-->
                                    <td style="text-align: center;">
                                        <a href="<?php echo e(route('show', $question->id)); ?>">
                                            <i class="fas fa-eye" title="View"></i>
                                        </a>
                                        <a href="<?php echo e(route('edit', $question->id)); ?>">
                                            <i class="fas fa-pencil-alt" title="Edit"></i>
                                        </a>
                                        <!--<a href="<?php echo e(route('destroy', $question->id)); ?>" onclick="event.preventDefault(); if(confirm('Are you sure?')) { document.getElementById('delete-form-<?php echo e($question->id); ?>').submit(); }">-->
                                        <!--    <i class="fas fa-trash" title="Delete"></i>-->
                                        <!--</a>-->
                                        <!--<form id="delete-form-<?php echo e($question->id); ?>" method="POST" action="<?php echo e(route('destroy', $question->id)); ?>" style="display: none;">-->
                                        <!--    <?php echo csrf_field(); ?>-->
                                        <!--    <?php echo method_field('DELETE'); ?>-->
                                        <!--</form>-->
                                           <a href="#" onclick="showDeleteModal(<?php echo e($question->id); ?>)">
                                                     <i class="fas fa-trash" title="Delete"></i>
                                            </a>
                                            <form id="delete-form-<?php echo e($question->id); ?>" method="POST" action="<?php echo e(route('destroy', $question->id)); ?>" style="display: none;">
                                              <?php echo csrf_field(); ?>
                                              <?php echo method_field('DELETE'); ?>
                                            </form>
                                        
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                       
                   
                </table>
            </div>
           
        </div>
    </div>
</div>
<!-- Bootstrap Modal -->
<div class="modal" id="deleteModal">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-body">
        Are you sure you want to delete this question?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-danger" onclick="deleteQuestion()">Delete</button>
      </div>
    </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
  var deleteQuestionId;

  function showDeleteModal(questionId) {
    deleteQuestionId = questionId;
    $('#deleteModal').modal('show');
  }

  function deleteQuestion() {
    $('#deleteModal').modal('hide');
    var deleteForm = document.getElementById('delete-form-' + deleteQuestionId);
    deleteForm.submit();
  }
</script>
    </body>

</html><?php /**PATH /home/telemeduser/public_html/IAN-Quiz/resources/views/listing.blade.php ENDPATH**/ ?>