<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Question;
use App\Models\Options;
use App\Models\UserAnswer;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Log;


class QuizController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    //    dd(Auth::user());
            $questions = DB::table('questions')->whereDate('q_date', '=', Carbon::today()->toDateString())->first();
           
            //dd($questions);
           
            $options = DB::table('options')->where('question_id',$questions->id)->get();
            // dd($options) ;
            return view('quiz',compact('questions','options'));
    }

    

    public function question(Request $request){
        // dd($request->all());
        try{
            // dd($request->all());
            $question =[
              
            // 'member_id' => $request->member_id,
                  'member_id' =>  Auth::member()->member_id,
                 'question_id' => $request->question,
                  'option_id'=> $request->answer,
                
            ];
            dd($question);
            UserAnswer::create($question);

            // $que =[
            //     'answer'=> $request->opt1
            // ];
          
            $correctAnswer = Options::select('id','is_correct')->where('question_id',$request->question)
            ->where('is_correct',1)
            ->orwhere('id',$request->answer)
            // ->orwhere('member_id',$request->member_id)
            ->get();
            // dd($correctAnswer);
            

            return $correctAnswer;
           
        } catch (\Exception $ex) {
            Log::info("Exception for question");
            Log::info($ex);
            // return redirect()->back();
            return $ex;
        }
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    

    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
