@extends('layout.login_layout')


@section('title', 'Login')

@section('body')

<section id="membership" class="membership section">
    <div class="container">

        <div class="row mb-4 mt-3">
            <div class="col-md-12 text-center">
                <h1 class="text-white"><strong>Member Login</strong></h1>

                @if(session('error'))
                    <div class="alert alert-danger text-center mt-3">
                        {{ session('error') }}
                    </div>
                @endif
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-6 m-auto">

                <!-- Tabs -->
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                            data-bs-target="#home" type="button" role="tab">Member</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                            data-bs-target="#profile" type="button" role="tab">Non Member</button>
                    </li>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content" id="myTabContent">

                    <!-- MEMBER TAB -->
                    <div class="tab-pane fade show active" id="home" role="tabpanel">
                        <div class="split-form">
                            <div class="form-side">

                                <form class="row g-3 needs-validation" method="POST" action="{{ route('abstract.login.submit') }}">
                                    @csrf

                                    <div class="row mt-4">
                                        <div class="col-md-4 mt-2">
                                            <p>Membership Type:</p>
                                        </div>

                                        <div class="col-md-4 mt-2">
                                            <select id="membershiptype" name="membershiptype" class="contact-form" required>
                                                <option value="">Membership type</option>
                                                <option value="Regular Membership">Regular Membership</option>
                                                <option value="Founding Membership">Founding Membership</option>
                                                <option value="Associate Membership">Associate Membership</option>
                                                <option value="Student Membership">Student Membership</option>
                                            </select>
                                        </div>

                                        <div class="col-md-4 mt-2">
                                            <input type="number" class="contact-form" id="membershipnumber"
                                                placeholder="Membership No" name="membershipnumber" required>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-md-4 mt-2">
                                            <p>Register Email / Mobile:</p>
                                        </div>

                                        <div class="col-md-8 mt-2">
                                            <input type="text" class="contact-form" id="regiemailnumber"
                                                placeholder="Email / Mobile No." name="regiemailnumber" required>
                                        </div>
                                    </div>

                                    <div class="col-3 justify-content-center d-flex align-items-center m-auto p-3">
                                        <input type="submit" value="Login" class="btn-login m-auto p-3 w-100">
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-6 justify-content-center d-flex align-items-center m-auto p-3">
                                            <strong>Not a member?
                                                <a class="small" href="#">Apply Now</a>
                                            </strong>
                                        </div>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>

                    <!-- NON MEMBER TAB -->
                    <div class="tab-pane fade" id="profile" role="tabpanel">
                        <div class="split-form">
                            <div class="form-side">

                                <form class="row g-3 needs-validation" method="POST" action="{{ route('abstract.login.submit') }}">
                                    @csrf

                                    <div class="row mt-4">
                                        <div class="col-md-4 mt-2">
                                            <p>Email ID:</p>
                                        </div>

                                        <div class="col-md-8 mt-2">
                                            <input type="email" class="contact-form"
                                                placeholder="Email Id" name="non-memberemail" required>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-md-4 mt-2">
                                            <p>Password:</p>
                                        </div>

                                        <div class="col-md-8 mt-2">
                                            <input type="password" class="contact-form"
                                                placeholder="Password" name="password" required>
                                        </div>
                                    </div>

                                    <div class="col-3 justify-content-center d-flex align-items-center m-auto p-3">
                                        <input type="submit" value="Login" class="btn-login m-auto p-3 w-100">
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>

                </div> <!-- END TAB CONTENT -->

            </div>
        </div>

    </div>
</section>

@endsection
