
// Get a reference to the element you want to animate
const element = document.getElementById('myElement');

gsap.registerPlugin(MotionPathPlugin, ScrollTrigger);
// Set up the motion path using an SVG path string or an array of points
const motionPath = [
    { x: 0, y: 0, stroke: 'red' },
    { x: '50vw', y: '100vh' },
    { x: '25vw', y: '200vh' },
    { x: '75vw', y: '300vh' },
    { x: '0vw', y: '400vh' }
];

// Create the timeline
const timeline = gsap.timeline({
    defaults: {
        duration: 1, // Animation duration
        // ease: 'power1.inOut', // Easing function
        ease: "slow",
    },
    scrollTrigger: {
        trigger: element, // Element that triggers the animation
        start: 'top 10%', // Start the animation when element is 80% in view
        end: 'bottom 0%', // End the animation when element is 20% in view
        // end: "+=" + (window.innerHeight * 2),
        scrub: true, // Smoothly animate on scroll
        // markers: true,
    },
});

// Add the motion path animation to the timeline
timeline.fromTo(element,
    { x: "0", y: "0vh" },
    {
        // ease: "slow",
        // , rotation: "100deg"
        motionPath:
        {
            path: [
                { x: '5vw', y: '40vh', scale: 1 },
                { x: '-5vw', y: '45vh', scale: 1 },
                // { x: '5vw', y: '10vh', scale: 1 },
                // { x: '-25vw', y: '10vh', scale: 1 },
                { x: '-75vw', y: '40vh', scale: 1.8 },
                { x: '-70vw', y: '50vh', scale: 0.6 },
                // { x: '-40vw', y: '50vh', scale: 0.4 },
                { x: '-5vw', y: '50vh', scale: 0.4 },
                // { x: '-10vw', y: '50vh', scale: 0.6 },
                { x: '-10vw', y: '96vh', scale: 1 },
                // { x: '0vw', y: '40vh', scale: 0 }
            ],
            // autoRotate: 300,
            // offsetY: -15
            // alignOrigin: [0.5, 0.5],
        }
    }
    // motionPath: {
    // path: motionPath,
    // path: "#motionPath",
    // align: "#motionPath",
    // alignOrigin: [0.5, 0.5],
    // Enable auto rotation along the path
    // },
);
